import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';
import 'package:viserpay/data/model/global/user/user_model.dart';

AirtimeCountryModel airtimeCountryModelFromJson(String str) => AirtimeCountryModel.fromJson(json.decode(str));

class AirtimeCountryModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  AirtimeCountryModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AirtimeCountryModel.fromJson(Map<String, dynamic> json) => AirtimeCountryModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );
}

class Data {
  List<Country>? countries;
  GlobalUser? user;
  AirTimeCharge? charge;
  Data({
    this.countries,
    this.user,
    this.charge,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        countries: json["countries"] == null ? [] : List<Country>.from(json["countries"]!.map((x) => Country.fromJson(x))),
        user: json['user'] == null ? null : GlobalUser.fromJson(json['user']),
        charge: json['charge'] == null ? null : AirTimeCharge.fromJson(json['charge']),
      );
}

class Country {
  int? id;
  String? name;
  String? isoName;
  String? continent;
  String? currencyCode;
  String? currencyName;
  String? currencySymbol;
  String? flagUrl;
  List<String>? callingCodes;
  String? status;
  dynamic createdAt;
  dynamic updatedAt;

  Country({
    this.id,
    this.name,
    this.isoName,
    this.continent,
    this.currencyCode,
    this.currencyName,
    this.currencySymbol,
    this.flagUrl,
    this.callingCodes,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Country.fromJson(Map<String, dynamic> json) => Country(
        id: json["id"],
        name: json["name"] != null ? json["name"].toString() : "",
        isoName: json["iso_name"] != null ? json["iso_name"].toString() : "",
        continent: json["continent"] != null ? json["continent"].toString() : "",
        currencyCode: json["currency_code"] != null ? json["currency_code"].toString() : "",
        currencyName: json["currency_name"] != null ? json["currency_name"].toString() : "",
        currencySymbol: json["currency_symbol"] != null ? json["currency_symbol"].toString() : "",
        flagUrl: json["flag_url"] != null ? json["flag_url"].toString() : "",
        callingCodes: json["calling_codes"] == null ? [] : List<String>.from(json["calling_codes"]!.map((x) => x)),
        status: json["status"] != null ? json["status"].toString() : "",
        createdAt: json["created_at"] != null ? json["created_at"].toString() : "",
        updatedAt: json["updated_at"] != null ? json["updated_at"].toString() : "",
      );
}

class AirTimeCharge {
  String? id;
  String? slug;
  String? fixedCharge;
  String? percentCharge;
  String? minLimit;
  String? maxLimit;
  String? agentCommissionFixed;
  String? agentCommissionPercent;
  String? merchantFixedCharge;
  String? merchantPercentCharge;
  String? monthlyLimit;
  String? dailyLimit;
  String? dailyRequestAcceptLimit;
  String? cap;
  String? createdAt;
  String? updatedAt;

  AirTimeCharge({
    this.id,
    this.slug,
    this.fixedCharge,
    this.percentCharge,
    this.minLimit,
    this.maxLimit,
    this.agentCommissionFixed,
    this.agentCommissionPercent,
    this.merchantFixedCharge,
    this.merchantPercentCharge,
    this.monthlyLimit,
    this.dailyLimit,
    this.dailyRequestAcceptLimit,
    this.cap,
    this.createdAt,
    this.updatedAt,
  });

  factory AirTimeCharge.fromJson(Map<String, dynamic> json) => AirTimeCharge(
        id: json["id"].toString(),
        slug: json["slug"].toString(),
        fixedCharge: json["fixed_charge"].toString(),
        percentCharge: json["percent_charge"].toString(),
        minLimit: json["min_limit"].toString(),
        maxLimit: json["max_limit"].toString(),
        agentCommissionFixed: json["agent_commission_fixed"].toString(),
        agentCommissionPercent: json["agent_commission_percent"].toString(),
        merchantFixedCharge: json["merchant_fixed_charge"].toString(),
        merchantPercentCharge: json["merchant_percent_charge"].toString(),
        monthlyLimit: json["monthly_limit"].toString(),
        dailyLimit: json["daily_limit"].toString(),
        dailyRequestAcceptLimit: json["daily_request_accept_limit"].toString(),
        cap: json["cap"].toString(),
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "slug": slug,
        "fixed_charge": fixedCharge,
        "percent_charge": percentCharge,
        "min_limit": minLimit,
        "max_limit": maxLimit,
        "agent_commission_fixed": agentCommissionFixed,
        "agent_commission_percent": agentCommissionPercent,
        "merchant_fixed_charge": merchantFixedCharge,
        "merchant_percent_charge": merchantPercentCharge,
        "monthly_limit": monthlyLimit,
        "daily_limit": dailyLimit,
        "daily_request_accept_limit": dailyRequestAcceptLimit,
        "cap": cap,
        "created_at": createdAt?.toString(),
        "updated_at": updatedAt?.toString(),
      };
}
